// File: /docs/engineering/README.md
// Cursor Patch: Replace entire file content with the following

# Engineering Docs (Internal)

This folder contains the internal engineering documentation for **SaaS OS**.

It is the canonical source of truth for:
- **Contracts** (component behavior + API boundaries)
- **Patterns** (composition guidance; later)
- **Tokens docs** (semantic intent/philosophy; not raw token exports)

---

## Structure

/docs/engineering/
├─ contracts/        → Component contracts (V1 core asset)
├─ patterns/         → System patterns (V1.1+ unless already drafted)
├─ tokens/           → Token philosophy + semantic intent docs (not exports)
└─ README.md         → You are here

---

## Rules

- **Do not** treat this folder as raw exports.
  - Raw exports live in `/tokens-export/` at the package root (e.g., `tokens.json`, `tokens.css`, `tokens.ts`).
- **Do not** duplicate the same document in multiple formats here.
  - Markdown in this folder is the **source**.
  - PDFs are generated and shipped as downloadable artifacts.

---

## What to put where

### contracts/
- One file per component contract (Markdown).
- Naming: `Contract—ui-<component>.md`

### patterns/ (later)
- One file per pattern (e.g. `Pattern—form-layouts.md`, `Pattern—empty-loading-error.md`)
- Patterns must reference existing contracts (not redefine them).

### tokens/
- Explains **semantic meaning**, intended usage, and rules.
- Should reference token exports indirectly (e.g. “use `color.text.primary`”), but not embed raw JSON/CSS exports.

---

## Versioning

- Contracts are **locked** for V1 unless explicitly version-bumped.
- Patterns can evolve faster (V1.1+).
- Token philosophy can evolve, but must remain consistent with exports.

---

## Related

- Figma source of truth lives under `/figma/README.md`
- Raw token exports live under `/tokens-export/`